﻿<#
 ================================================================================== 
 NAME:        Office365AdministrationModule. 
 DESCRIPTION: Office365AdministrationModule is an advanced powershell module which you can use to quickly discover and change settings in Office 365 and Exchange.
 AUTHOR:      Nedim Mehic
 WEBSITE:     nedimmehic.org 
 ================================================================================== 
#>
FUNCTION Office365AdministrationModule { 
    
    param (

        [parameter(Mandatory = $true)]
        [pscredential]$admincreds
    )


    $l = "**************************************************************"
    $l2 = "______________________________________________________________"

    # Checking if MSOnline module is installed!
    Write-Host "Checking if MSOnline Office 365 Module is installed" -ForegroundColor Yellow

    IF (Get-Module -ListAvailable -Name MSOnline) {
        Write-Host "MSOnline Module found" -ForegroundColor Green
        Import-Module MSOnline | Out-Null
    }
    else {
        ''
        Write-Host "No MSOnline Module found. Installing MSOnline Office 365 Module." -ForegroundColor Cyan
        Install-Module -Name MSOnline -Force -Confirm:$false 
    }

    # Checking if AzureAD module is installed!
    Write-Host "Checking if AzureAD Module is installed" -ForegroundColor Yellow

    IF (Get-Module -ListAvailable -Name AzureAD) {
        Write-Host "AzureAD Module found" -ForegroundColor Green
        Import-Module AzureAD | Out-Null
    }
    else {
        ''
        Write-Host "No AzureAD Module found. Installing AzureAD Module." -ForegroundColor Cyan
        Install-Module -Name AzureAD -Force -Confirm:$false 
    }

    # Connecting to Exchange Online
    Write-Host "Connecting to Exchange Online" -ForegroundColor Yellow
    TRY {
        $session = New-PSSession -ConnectionUri https://outlook.office365.com/powershell-liveid/ -ConfigurationName Microsoft.Exchange -Credential $admincreds -Authentication Basic -AllowRedirection
        Import-PSSession $session -DisableNameChecking | Out-Null
        Write-Host "Succesfully Connected to Exchange Online" -ForegroundColor Green
    }

    CATCH {
        Write-Host "Unable to connect to Exchange Online. Please check your credentials and if you have required permissions!" -foregroundcolor red
        Throw 'Error'
    }

    # Connecting to Office 365
    Write-Host "Connecting to Office 365" -ForegroundColor Yellow
    TRY {
        Connect-MsolService -Credential $admincreds
        Write-Host "Succesfully Connected to Office 365" -ForegroundColor Green

    }

    CATCH {
        Write-Host "Unable to connect to Office 365. Please check if you have required permissions!" -foregroundcolor red
        Throw 'Error'
    }

    # Connecting to Azure AD
    Write-Host "Connecting to Azure AD" -ForegroundColor Yellow
    TRY {
        Connect-AzureAD -Credential $admincreds | out-null   
        Write-Host "Succesfully Connected to Azure AD" -ForegroundColor Green

    }

    CATCH {
        Write-Host "Unable to connect to Azure AD. Please check if you have required permissions!" -foregroundcolor red
        Throw 'Error'
    }

    Clear-Host


    DO {

        $l
        Write-Host ""
        Write-Host " OFFICE 365 ADMINISTRATION MODULE " -ForegroundColor Yellow
        Write-Host " Created By Nedim Mehic | NEDIMMEHIC.ORG " -ForegroundColor Yellow
        Write-Host " Version : 1.0 " -ForegroundColor Yellow
        Write-Host ""
        $l
        Write-Host ""
        Write-Host ""
        Write-Host " 1) OFFICE 365 SECTION" -ForegroundColor Yellow
        Write-Host ""
        Write-Host ""
        Write-Host " 2) EXCHANGE ONLINE SECTION" -ForegroundColor Yellow
        Write-Host ""
        
        Write-Host ""
        $i = Read-Host 'Please choose the section to continue'

        Clear-Host

        Switch ($i) {


            1 {
                DO {
                    Write-Host "OFFICE 365 SECTION" -ForegroundColor Green
                    Write-Host ''
                    Write-Host " 1) ENABLE MODERN AUTHENTICATION IN OFFICE 365" -ForegroundColor Cyan
                    Write-Host " 2) ENABLE OFFICE 365 MFA FOR A SPECIFIC USER" -ForegroundColor Cyan
                    Write-Host " 3) ENABLE OFFICE 365 MFA FOR ALL USERS" -ForegroundColor Cyan
                    Write-Host " 4) GET ALL LICENSES AND USAGE" -ForegroundColor Cyan
                    Write-Host " 5) FIND OUT WHEN THE LICENSE WAS ASSIGNED TO USER" -ForegroundColor Cyan
                    Write-Host " 6) START AD CONNECT SYNC" -ForegroundColor Cyan
                    Write-Host " 7) LOG OFF USER FROM ALL OFFICE 365 SERVICES AND APPS" -ForegroundColor Cyan
                    Write-Host " 8) LIST OF ALL ADMIN ROLES AND PEOPLE WHO HOLDS THEM" -ForegroundColor Cyan
                    Write-Host " 9) CREATE OFFICE 365 HIDDEN GROUP" -ForegroundColor Cyan
                    Write-Host " 10) ENABLE OFFICE 365 LOG AUDITING" -ForegroundColor Cyan
                    Write-Host ' 0) Quit' -ForegroundColor Green

                    Write-Host ""
                    $scope = Read-Host 'Please choose the section to continue' 
                    Clear-Host

                    Switch ($scope) {

                        1 {Clear-Host
                           Write-host "Checking if Modern Authentication is enabled" -ForegroundColor Yellow
                            IF ((Get-OrganizationConfig).OAuth2ClientProfileEnabled -eq $true)  {
                                Write-Host "Modern Authentication is enabled" -ForegroundColor Green
                            } 

                            ELSE {
                                Write-Host "Modern Authentication is not enabled. Activating Modern Authentication..." -ForegroundColor Yellow
                            }   Set-OrganizationConfig -OAuth2ClientProfileEnabled $True 

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }



                        2 { Clear-Host
                            $username = Read-Host = 'Please specify username? Help = Username format: username@domain.com'

                            $authentication = New-Object -TypeName Microsoft.Online.Administration.StrongAuthenticationRequirement
                            $authentication.RelyingParty = '*'
                            $authentication.State = "Enabled"
                            $authentication.RememberDevicesNotIssuedBefore = (Get-Date)

                            Write-Host "Activating MFA for" (Get-MsolUser -UserPrincipalName $username).displayname -ForegroundColor Yellow
                            Set-MsolUser -UserPrincipalName $username -StrongAuthenticationRequirements $authentication

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }


                        3 { Clear-Host
                            $authentication = New-Object -TypeName Microsoft.Online.Administration.StrongAuthenticationRequirement
                            $authentication.RelyingParty = '*'
                            $authentication.State = "Enabled"
                            $authentication.RememberDevicesNotIssuedBefore = (Get-Date)

                            Write-Host "Activating MFA for all users" -ForegroundColor Yellow
                            $users = Get-MsolUser -All | ? {$_.islicensed -EQ 'true' -or $_.userprincipalname -like '*admin*'}
                             
                            $users.Foreach{ Set-MsolUser -UserPrincipalName $_.userprincipalname -StrongAuthenticationRequirements $authentication }

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }


                        4 { Clear-Host
                            $tenant = (Get-MsolCompanyInformation).displayname
                            Write-Host "License Report for a tenant :" $tenant -ForegroundColor Yellow

                            $licenses = (Get-AzureADSubscribedSku)
                            $licenses | Select -Property SkuPartNumber, ConsumedUnits -ExpandProperty PrepaidUnits | Ft

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }



                        5 { Clear-Host
                            $username = Read-Host = 'Please specify username?'

                            Write-Host "Getting report of the date and time when the license was assigned to the user :" (Get-AzureADUser -ObjectId $username).displayname  -ForegroundColor Yellow
                            Get-AzureADUser -ObjectId $username | Select -ExpandProperty AssignedPlans | ft

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }

                        6 { Clear-Host
                            $computername = Read-Host = 'Please specify computername?'
                            $cred = Get-Credential
                            Write-Host "Executing AD Sync command" -ForegroundColor Yellow
                            Invoke-Command -ComputerName $computername -Credential $cred { Start-ADSyncSyncCycle -PolicyType Delta }
                        
                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }



                        7 { Clear-Host
                            $userprincipalname = Read-Host = 'Please specify userprincipalname'
                            $userprincipalname = (Get-AzureADUser -ObjectId $userprincipalname).displayname
                            Write-Host "Signing out $userprincipalname from all Office 365 sessions" -ForegroundColor Yellow
                            Revoke-AzureADUserAllRefreshToken -ObjectId $userprincipalname
                        
                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }


                        8 {Clear-Host
                            Write-host " Getting list of know admin roles and the people who hold those roles" -ForegroundColor Yellow
                            Get-AzureADDirectoryRole | foreach { $Role = $_.DisplayName; Get-AzureADDirectoryRoleMember -ObjectId $_.ObjectId } | 
                            Format-Table @{Name = "Role"; Expression = { $Role } }, DisplayName, UserPrincipalName -AutoSize

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }

                        9 {
                            Clear-Host
                            $Office365GroupName = Read-Host = 'Please specify name you would like to use?'
                            $Alias = Read-Host = 'Please specify alias?'

                            
                            Write-Host "Checking if the group already exists?" -ForegroundColor Yellow
                            $group = Get-UnifiedGroup -Identity $Office365GroupName -ErrorAction silentlycontinue

                            IF (!$group) {
                                Write-Host 'Creating new unified group :' $Office365GroupName -ForegroundColor Yellow
                                New-UnifiedGroup -DisplayName $Office365GroupName -Alias $Alias -AccessType Private -HiddenGroupMembershipEnabled 
                            }
                            
                            ELSE {
                                Write-Host "Group already exist!" -ForegroundColor Red
                                Throw 'Error' 
                            }

                            
                            DO {
                                $Office365Group = Get-UnifiedGroup -Identity $Office365GroupName -ErrorAction SilentlyContinue | fw IsValid
                                Start-Sleep -Seconds 5 
                            }
                                
                            While (!$Office365Group)

                            Write-Host "Hidding $Office365GroupName group from the Address Lists" -ForegroundColor Yellow
                            Set-UnifiedGroup -Identity $Office365GroupName -HiddenFromAddressListsEnabled $true

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }


                        10 {Clear-Host
                            Write-Host "Checking if Office 365 Audit Log Search is enabled" -ForegroundColor Yellow
                            $logauditing = Get-AdminAuditLogConfig
                        
                            IF ($logauditing.UnifiedAuditLogIngestionEnabled -eq $true) {
                                Write-host "Audit Log Search is enabled" -ForegroundColor Green
                            }
                            
                            ELSE { 
                                Write-host "Enabling Audit Log Search in Office 365" -ForegroundColor Yellow
                                Set-AdminAuditLogConfig -UnifiedAuditLogIngestionEnabled $true 
                            }
                            
                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host

                        }
                    }        
                }
                while ($scope -ne '0')
                Clear-Host
            }


            2 {
                DO {
                    Write-Host "EXCHANGE ONLINE SECTION" -ForegroundColor Green    
                    Write-Host ''
                    Write-Host " 1) SCAN ALL INBOX RULES (AUTO-FORWARDING SCAN)" -ForegroundColor Cyan
                    Write-Host " 2) CREATE MAIL FLOW RULE TO BLOCK EXTERNAL FORWARDING" -ForegroundColor Cyan
                    Write-Host " 3) BLOCK FORWARDING IN OWA (ALL USER AND SHARED MAILBOXES)" -ForegroundColor Cyan
                    Write-Host " 4) BLOCK IMAP / POP3 FOR ALL MAILBOXES AND MAILBOX PLANS" -ForegroundColor Cyan
                    Write-Host " 5) BLOCK BASIC AUTHENTICATION IN EXCHANGE" -ForegroundColor Cyan
                    Write-Host " 6) EXPORT DKIM SELECTOR CNAME RECORDS FROM ALL DOMAINS" -ForegroundColor Cyan
                    Write-Host " 7) ENABLE LITIGATION HOLD FOR A SPECIFIC USER MAILBOX" -ForegroundColor Cyan
                    Write-Host " 8) ENABLE LITIGATION HOLD FOR ALL USER MAILBOXES" -ForegroundColor Cyan
                    Write-Host " 9) ENABLE ARCHIVE FOR A SPECIFIC USER MAILBOX" -ForegroundColor Cyan
                    Write-Host " 10) ENABLE ARCHIVE FOR ALL USER MAILBOXES" -ForegroundColor Cyan
                    Write-Host " 11) GET MEMBERS OF DYNAMIC DISTRIBUTION GROUP" -ForegroundColor Cyan
                    Write-Host " 12) GET CALENDAR SHARING INFO" -ForegroundColor Cyan
                    Write-Host ' 0) Quit' -ForegroundColor Green

                    $scope = Read-Host 'Please choose the section to continue'
                    Write-Host ""

                    Switch ($scope) {
                

                        1 { Clear-Host
                            Write-Host "Discovering inbox rules that have external forwarding configured" -ForegroundColor Yellow
                            $mailboxes = get-mailbox –resultSize unlimited
                            $rules = $mailboxes | % { get-inboxRule –mailbox $_.UserPrincipalName }                            
                            $rules | ? { ($_.forwardAsAttachmentTo -ne "") -or ($_.forwardTo -ne "") -or ($_.redirectTo -ne "") -or ($_.MoveToFolder -like "RSS-*") } | select name, MailboxOwnerId, identity, ruleidentity, description | fl

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }

                        2 { Clear-Host
                            $MailflowRule = "Inbox Rule To Block External Forwarding"
                            $rejectMessage = "To improve security, auto-forwarding rules to external addresses have been disabled. Please contact IT Department if you'd like to set up an exception."
 
                            $ExternalMailFlowRules = Get-TransportRule | Where-Object { $_.Identity -contains $MailflowRule }
 
                            IF (!$ExternalMailFlowRules) {
                                Write-Host "Client Rules To Block External Forwarding not found, creating new Mail Flow Rule" -ForegroundColor Yellow
                                New-TransportRule -name $MailflowRule -Priority 0 -SentToScope NotInOrganization -FromScope InOrganization -MessageTypeMatches AutoForward -RejectMessageEnhancedStatusCode 5.7.1 -RejectMessageReasonText $rejectMessage | Out-Host
                            }
                            
                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }


                        3 { Clear-Host
                            $RoleAssignmentPolicyName = Read-Host = 'Please type in the name you would like to use for the new Role Assignment Policy?'
                        

                            $roles = 'MyTeamMailboxes', 'My Marketplace Apps', 'My Custom Apps', 'My ReadWriteMailbox Apps', 'MyContactInformation',
                            'MyMailSubscriptions', 'MyProfileInformation', 'MyRetentionPolicies', 'MyDistributionGroupMembership', 'MyDistributionGroups', 'MyTextMessaging', 'MyVoiceMail', 'MyBaseOptions-DisableOWAForwarding'

                            $mailboxes = (Get-Mailbox -ResultSize Unlimited -RecipientTypeDetails UserMailbox, SharedMailbox).identity 


                            Write-Host "Creating new management role based on MyBaseOptions role" -ForegroundColor Yellow
                            New-ManagementRole -Name MyBaseOptions-DisableOWAForwarding -Parent MyBaseOptions | Out-Null

                            DO {
                                $managementrole = Get-ManagementRole -Identity MyBaseOptions-DisableOWAForwarding -ErrorAction SilentlyContinue | fw IsValid
                                Start-Sleep -Seconds 5 
                            }
                                
                            While (!$managementrole)

                            Write-Host "Removing forwarding parameters from MyBaseOptions-DisableOWAForwarding role" -ForegroundColor Yellow
                            Set-ManagementRoleEntry MyBaseOptions-DisableOWAForwarding\Set-Mailbox -RemoveParameter -Parameters DeliverToMailboxAndForward, ForwardingAddress, ForwardingSmtpAddress

                            Write-Host "Creating New Role Assignment Policy" -ForegroundColor Yellow
                            New-RoleAssignmentPolicy -Name $RoleAssignmentPolicyName -Roles $roles | Out-Null

                            Write-Host "Assigning $RoleAssignmentPolicyName to all shared and user mailboxes" -ForegroundColor Yellow

                            $mailboxes.foreach{ Set-Mailbox -Identity $_ -RoleAssignmentPolicy $RoleAssignmentPolicyName }
                            Write-Host "All Done!" -ForegroundColor Green

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }


                        4 { Clear-Host
                            Write-Host "Checking if IMAP and POP protocols are enabled" -ForegroundColor Yellow
                            $plans = Get-MailboxPlan | Get-CASMailboxPlan | ? { $_.ImapEnabled -eq 'True' -or $_.Popenabled -eq 'True' }

                            IF (!$plans) {
                                Write-Host "IMAP and POP protocols are disabled for new mailboxes" -ForegroundColor Green
                            }

                            else {
                                Write-Host "IMAP and POP protocols are not disabled for new mailboxes. Disabling IMAP and POP protocols " -ForegroundColor Yellow
                                Get-MailboxPlan | Set-CASMailboxPlan -PopEnabled $False -IMAPEnabled $False
                            }

                            Write-Host "Disabling IMAP and POP protocols for existing mailboxes" -ForegroundColor Yellow
                            $mbx = (Get-CASMailbox | ? { $_.ImapEnabled -eq 'True' -or $_.Popenabled -eq 'True' }).identity

                            $mbx.Foreach{ Set-CASMailbox -Identity $_ -ImapEnabled $false -PopEnabled $false }
                            Write-Host "All Done!" -ForegroundColor Green

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }

                        5 { Clear-Host
                            $authpolicy = "Block Basic Authentication"
                            Write-Host "Creating new Authentication Policy" -ForegroundColor Yellow
                            New-AuthenticationPolicy -Name $authpolicy | Out-Null

                            DO {
                                $authenticationpolicy = Get-AuthenticationPolicy -Identity $authpolicy -ErrorAction SilentlyContinue | fw IsValid
                                Start-Sleep -Seconds 2 
                            }
                                
                            While (!$authenticationpolicy)

                            Write-Host "Enabling Basic Authentication for Powershell" -ForegroundColor Yellow
                            Set-AuthenticationPolicy -Identity $authpolicy -AllowBasicAuthPowershell:$true

                            Write-Host "Assigning policy to all existing users"
                            Get-Recipient -RecipientTypeDetails UserMailbox -ResultSize Unlimited | Set-User -AuthenticationPolicy $authpolicy -STSRefreshTokensValidFrom $([System.DateTime]::UtcNow)

                            Write-host "Assigning $authpolicy policy to all new users" -ForegroundColor Yellow
                            Set-OrganizationConfig -DefaultAuthenticationPolicy $authpolicy

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }

                        6 { Clear-Host
                            Write-Host "Getting list of all custom domains" -ForegroundColor Yellow
                            $customdomains = (Get-MsolDomain | ? { $_.name -NotLike '*.onmicrosoft.com' -and $_.status -like 'Verified' }).name 
    
                            $customdomains | foreach {

                                $dkimconfig = Get-DkimSigningConfig -Identity $_ -ErrorAction SilentlyContinue

                                IF (!($dkimconfig)) {
                                    Write-Host "Adding domain to DKIM Signing Configuration" : $_ -ForegroundColor Yellow
                                    New-DkimSigningConfig -DomainName $_ -Enabled $false
                                }           
                            }

                            Write-Host "Collecting Selector1 and Selector2 CNAME records from all domains" -ForegroundColor Yellow
                            Get-DkimSigningConfig | select domain, Selector1CNAME, Selector2CNAME | fl | Out-File C:\dkimsigningkeys.txt

                            notepad C:\dkimsigningkeys.txt

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }
                          

                        7 { Clear-Host
                            $username = Read-Host = 'Please type in the username. Example: username@domain.com'
                            

                            IF ($username) {
                                Write-Host "Checking if the user exists" -ForegroundColor Yellow
                                $mailbox = Get-Mailbox -Identity $username
                            }

                            IF (!$mailbox.LitigationHoldEnabled) {

                                Write-Host "Enabling Litigation hold on :" (Get-AzureADUser -ObjectId $username).displayname -ForegroundColor Yellow
                                Set-Mailbox -Identity $username -LitigationHoldEnabled $true
                            }

                            ELSEIF ($mailbox.LitigationHoldEnabled) { Write-Host "Litigation Hold is already enabled on :" (Get-AzureADUser -ObjectId $username).displayname -ForegroundColor Green }


                            Else {
                                Write-Host "Username does not exist! Please try again?" -ForegroundColor Red
                                Throw 'Error'
                            } 

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }

                        8 { Clear-Host
                            Write-Host "Getting list of all user mailboxes" -ForegroundColor Yellow
                            $mailboxes = (Get-Mailbox -ResultSize Unlimited -RecipientTypeDetails UserMailbox).identity

                            $mailboxes.foreach{

                                IF (!$m.LitigationHoldEnabled) {

                                    Write-Host "Enabling Litigation hold on :" $_ -ForegroundColor Yellow
                                    Set-Mailbox -Identity $_ -LitigationHoldEnabled $true |Out-Null
                                }
                            }

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }

                        
                        9 { Clear-Host
                            $username = Read-Host = 'Please type in the username'

                            IF ($username) {
                                Write-Host "Checking if the user exists" -ForegroundColor Yellow
                                $mailbox = Get-Mailbox -Identity $username
                            }

                            IF ($mailbox.ArchiveStatus -eq 'None') {

                                Write-Host "Enabling Archive on :" (Get-AzureADUser -ObjectId $username).displayname -ForegroundColor Yellow
                                Enable-Mailbox -Identity $username -Archive
                            }

                            ELSEIF ($mailbox.ArchiveStatus -eq 'Active') { Write-Host "Archive is already enabled on :" (Get-AzureADUser -ObjectId $username).displayname -ForegroundColor Green }

                            Else {
                                Write-Host "Username does not exist! Please try again?" -ForegroundColor Red
                                Throw 'Error' 
                            }
                                
                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }

                        
                        10 {Clear-Host
                            Write-Host "Getting list of all user mailboxes" -ForegroundColor Yellow
                            $mailboxes = Get-Mailbox -ResultSize Unlimited -RecipientTypeDetails UserMailbox

                            foreach ($m in $mailboxes) {

                                IF ($m.ArchiveStatus -eq 'None') {

                                    Write-Host "Enabling Archive on :" $m.identity -ForegroundColor Yellow
                                    Enable-Mailbox -Identity $m.Identity -Archive | Out-Null
                                }
                            }

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }

                        11 {Clear-Host
                            $GroupName = Read-Host = 'Please type in the groupname'
                            
                            Write-Host "Getting list of all users that are member of :" $groupname
                            Get-Recipient -RecipientPreviewFilter (Get-DynamicDistributionGroup -Identity $groupname).recipientfilter | ft -AutoSize

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }

                        12 {Clear-Host
                            Write-Host "Generating list of all calendar sharing (Internal / External)" -ForegroundColor Yellow 
                            ((Get-Mailbox –RecipientTypeDetails UserMailbox).Alias) | % { Get-MailboxFolderPermission –Identity ($_ + ":\Calendar") } | ? { $_.User –notlike "Anonymous" } | Ft Identity, FolderName, User –AutoSize

                            Read-Host 'Type 0 or press enter to go back to the main menu'
                            Clear-Host
                        }
                    }
                }
                
                while ($scope -ne '0')  
                Clear-Host           
            }
        }
    }
    while ($i -ne '0')
}

    

            