#Region '.\prefix.ps1' -1

$script:dscResourceCommonModulePath = Join-Path -Path $PSScriptRoot -ChildPath '../DscResource.Common'

Import-Module -Name $script:dscResourceCommonModulePath

$script:localizedData = Get-LocalizedData -DefaultUICulture 'en-US'
#EndRegion '.\prefix.ps1' 6
#Region '.\Public\Get-RemoteDesktopServicesDscOsVersion.ps1' -1

function Get-RemoteDesktopServicesDscOsVersion
{
    [CmdletBinding()]
    [OutputType([System.Version])]
    param ()

    return [Environment]::OSVersion.Version
}
#EndRegion '.\Public\Get-RemoteDesktopServicesDscOsVersion.ps1' 9
#Region '.\Public\Test-RemoteDesktopServicesDscOsRequirement.ps1' -1

<#
    .SYNOPSIS
        Verifies that the operating system meets the Remote Desktop st requirement.

    .DESCRIPTION
        Returns $true when Get-RemoteDesktopServicesDscOsVersion reports at least Windows Server 2012 (6.2.9200.0); otherwise returns $false.

    .OUTPUTS
        System.Boolean

        Indicates whether the OS version is supported.

    .EXAMPLE
        Test-RemoteDesktopServicesDscOsRequirement

        Returns $true if the OS is Windows Server 2012 or later, otherwise $false.
#>

function Test-RemoteDesktopServicesDscOsRequirement
{
    [CmdletBinding()]
    [OutputType([System.Boolean])]
    param ()

    return (Get-RemoteDesktopServicesDscOsVersion) -ge ([System.Version]::new(6, 2, 9200, 0))
}
#EndRegion '.\Public\Test-RemoteDesktopServicesDscOsRequirement.ps1' 27
