@{
    # Script module or binary module file associated with this manifest.
    RootModule           = 'RemoteDesktopServicesDsc.psm1'

    # Version number of this module. This is controlled by gitversion.
    moduleVersion        = '4.0.0'

    # ID used to uniquely identify this module
    GUID                 = 'b42ff085-bd2b-4232-90ba-02b4c780e2d9'

    # Author of this module
    Author               = 'DSC Community'

    # Company or vendor of this module
    CompanyName          = 'DSC Community'

    # Copyright statement for this module
    Copyright            = 'Copyright the DSC Community contributors. All rights reserved.'

    # Description of the functionality provided by this module
    Description          = 'Module with DSC Resources for Remote Desktop Services'

    # Minimum version of the Windows PowerShell engine required by this module
    PowerShellVersion    = '5.0'

    # Minimum version of the common language runtime (CLR) required by this module
    CLRVersion           = '4.0'

    # Functions to export from this module
    FunctionsToExport    = @()

    # Cmdlets to export from this module
    CmdletsToExport      = @()

    # DSC resources to export from this module
    DscResourcesToExport = @('RDCertificateConfiguration','RDConnectionBrokerHAMode','RDGatewayConfiguration','RDLicenseConfiguration','RDRemoteApp','RDServer','RDSessionCollection','RDSessionCollectionConfiguration','RDSessionDeployment')

    # Private data to pass to the module specified in RootModule/ModuleToProcess. This may also contain a PSData hashtable with additional module metadata used by PowerShell.
    PrivateData          = @{

        PSData = @{

            # Tags applied to this module. These help with module discovery in online galleries.
            Tags         = @('DesiredStateConfiguration', 'DSC', 'DSCResourceKit', 'DSCResource')

            # A URL to an icon representing this module.
            IconUri      = 'https://dsccommunity.org/images/DSC_Logo_300p.png'

            # A URL to the license for this module.
            LicenseUri   = 'https://github.com/dsccommunity/RemoteDesktopServicesDsc/blob/main/LICENSE'

            # Set to a prerelease string value if the release should be a prerelease.
            Prerelease   = ''

            # A URL to the main website for this project.
            ProjectUri   = 'https://github.com/dsccommunity/RemoteDesktopServicesDsc'

            # ReleaseNotes of this module
            ReleaseNotes = '## [4.0.0] - 2026-01-21

### Changed

- Renamed module to RemoteDesktopServicesDsc.
- Remove last references to old module name.

'

        } # End of PSData hashtable

    } # End of PrivateData hashtable
}
